import unittest
from unittest.mock import Mock


from todo.app import TODOApp


class TestTODOApp(unittest.TestCase):
    def test_noloader(self):
        app = TODOApp(io=(Mock(return_value="quit"), Mock()),
                      dbmanager=None)

        app.run()

        assert app._entries == []

    def test_load(self):
        dbmanager = Mock(
            load=Mock(return_value=["kupić mleko", "kupić wodę"])
        )
        app = TODOApp(io=(Mock(return_value="quit"), Mock()),
                      dbmanager=dbmanager)

        app.run()

        dbmanager.load.assert_called_with()
        assert app._entries == ["kupić mleko", "kupić wodę"]

    def test_save(self):
        dbmanager = Mock(
            load=Mock(return_value=["kupić mleko", "kupić wodę"]),
            save=Mock()
        )

        app = TODOApp(io=(Mock(return_value="quit"), Mock()),
                      dbmanager=dbmanager)
        app.run()

        dbmanager.save.assert_called_with(["kupić mleko", "kupić wodę"])
